% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chimpanzee_cameras.R
\docType{data}
\name{chimpanzee_cameras}
\alias{chimpanzee_cameras}
\title{Chimpanzee Camera Trap Detection Data}
\format{
A data frame with observations across multiple cameras and dates:
\describe{
\item{Camera}{Camera trap identifier (factor)}
\item{Latitude}{Latitude coordinates of the camera trap location (numeric)}
\item{Longitude}{Longitude coordinates of the camera trap location (numeric)}
\item{Method}{Camera placement method: 'systematic' or 'targeted' (factor)}
\item{Vegetation}{Vegetation type at camera location: 'open' or 'closed' (factor)}
\item{Topography}{Landscape feature at camera location: 'valley', 'slope', or 'plateau' (factor)}
\item{date}{Date of observation (Date)}
\item{detection}{Chimpanzee detection status: 'absent' or 'present' (factor)}
}
}
\source{
Crunchant, Anne-Sophie and Borchers, David and Kuehl, Hjalmar and Piel, Alex K. (2020).
Listening and watching: do camera traps or acoustic sensors more efficiently detect wild
chimpanzees in an open habitat?. Dryad Digital Repository.
\doi{10.5061/DRYAD.5DV41NS34}
}
\usage{
chimpanzee_cameras
}
\description{
This dataset contains presence/absence data for wild chimpanzees (Pan troglodytes)
detected by camera traps in the Issa Valley, Tanzania. The data was collected as part
of a study comparing the efficiency of camera traps versus passive acoustic monitoring
for detecting chimpanzees in a savanna-woodland mosaic habitat.
}
\details{
The dataset is in long format, with each row representing a camera trap observation
for a specific date. Detection values are coded as 'present' (at least one detection
during the day) or 'absent' (no detection). NA values indicate days when no survey was
conducted (e.g., due to camera malfunction or not being deployed).
}
\examples{
# Load the dataset
data(chimpanzee_cameras)

# Basic exploration
head(chimpanzee_cameras)
summary(chimpanzee_cameras)

\donttest{
# Count detections by camera (requires dplyr)
if (requireNamespace("dplyr", quietly = TRUE)) {
  library(dplyr)
  chimpanzee_cameras \%>\%
    group_by(Camera) \%>\%
    summarize(
      total_observations = n(),
      detections = sum(detection == "present", na.rm = TRUE),
      detection_rate = mean(detection == "present", na.rm = TRUE)
    )
}

# Visualize detection patterns over time (requires ggplot2)
if (requireNamespace("ggplot2", quietly = TRUE)) {
  library(ggplot2)
  ggplot(chimpanzee_cameras, aes(x = date, y = Camera, fill = detection)) +
    geom_tile() +
    scale_fill_manual(values = c("absent" = "lightblue", "present" = "darkred"),
                      na.value = "gray90") +
    theme_minimal() +
    labs(title = "Chimpanzee detections by camera over time",
         x = "Date", y = "Camera")
}
}
}
\keyword{datasets}
