% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whale_brains.R
\docType{data}
\name{whale_brains}
\alias{whale_brains}
\title{The Evolution of Hearing and Brain Size in Eocene Whales}
\format{
A data frame with 269 rows and 9 variables:
\describe{
\item{family}{Taxonomic family of the species}
\item{binomial_name}{Full taxonomic name for each species}
\item{common_name}{Common name for each species (NA for most fossil species)}
\item{endocranial_volume}{Endocranial volume in cubic centimeters (cc)}
\item{brain_mass}{Brain mass in grams}
\item{ocw_mm}{Occipital condyle width in millimeters}
\item{body_mass}{Body mass in kilograms}
\item{taxonomic_group}{Categorization as "Cetacean", "Hippopotamid", or "Other Mammal"}
\item{time_period}{Classification as "Extant" (living) or "Fossil" species}
}
}
\source{
Peacock, John and Waugh, David and Bajpai, Sunil and Thewissen, JGM (2025).
The evolution of hearing and brain size in Eocene whales. Dryad Digital Repository.
\doi{10.5061/DRYAD.SF7M0CGH1}
}
\usage{
whale_brains
}
\description{
A dataset containing endocranial volume and body mass measurements for various cetacean
(whale) species and other mammals. This dataset was compiled to study the evolution of
hearing and brain size in Eocene whales. It includes both extant (living) and fossil
species, with a focus on understanding how brain size evolved in relation to body mass
and hearing adaptations across different taxonomic groups. The dataset is particularly
valuable for teaching concepts in comparative anatomy, allometry, and cetacean evolution.
}
\details{
Toothed whales (odontocetes) use high-frequency sounds to echolocate, differing
significantly from baleen whales (mysticetes), which use low-frequency sound for
long-distance communication. This dataset helps explore how hearing functioned in
ancestral archaeocetes, and when the specializations of modern species arose.
}
\examples{
\donttest{
# Load the dataset
data(whale_brains)

# Basic exploration
head(whale_brains)
summary(whale_brains)

# Compare brain mass across taxonomic groups
boxplot(whale_brains$brain_mass ~ whale_brains$taxonomic_group, 
        main = "Brain Mass by Taxonomic Group",
        ylab = "Brain Mass (g)", log = "y")

# Look at the relationship between brain mass and body mass
# Using log scales to show allometric relationships
plot(whale_brains$body_mass, whale_brains$brain_mass, 
     log = "xy", col = as.numeric(whale_brains$taxonomic_group),
     pch = 16, main = "Brain Mass vs. Body Mass",
     xlab = "Body Mass (kg)", ylab = "Brain Mass (g)")
legend("topleft", legend = levels(whale_brains$taxonomic_group), 
       col = 1:3, pch = 16)
       
# Compare fossil and extant cetaceans
cetaceans <- subset(whale_brains, taxonomic_group == "Cetacean")
boxplot(cetaceans$brain_mass ~ cetaceans$time_period,
        main = "Brain Mass in Fossil vs. Extant Cetaceans",
        ylab = "Brain Mass (g)", log = "y")
}
}
\keyword{datasets}
