% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.dataprocessing.R
\name{addUnionGroup}
\alias{addUnionGroup}
\alias{addAllGroup}
\title{Grouping helpers}
\usage{
addUnionGroup(df, col, group, values)

addAllGroup(df, col, group = "all")
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data frame.}

\item{col}{[\code{character(1)}]\cr
Column name of group-column.}

\item{group}{[\code{character(1)}]\cr
Name for new group.}

\item{values}{[\code{character(1)}]\cr
Subset of values within the value range of column \code{col}.}
}
\value{
[\code{data.frame}] Modified data frame.
}
\description{
Consider a data frame with results of multi-objective stochastic optimizers on
a set of problems from different categories/groups (say indicated by column \dQuote{group}).
Occasionally, it is useful to unite the results of several groups into a meta-group.
The function \code{addUnionGroup} aids in generation of such a meta-group while
function \code{addAllGroup} is a wrapper around the former which generates a
union of all groups.
}
\examples{
df = data.frame(
  group = c("A1", "A1", "A2", "A2", "B"),
  perf = runif(5),
  stringsAsFactors = FALSE)

df2 = addUnionGroup(df, col = "group", group = "A", values = c("A1", "A2"))
df3 = addAllGroup(df, col = "group", group = "ALL")
}
