% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa.as-emoa.R
\name{asemoa}
\alias{asemoa}
\title{Implementation of the NSGA-II EMOA algorithm by Deb.}
\usage{
asemoa(
  fitness.fun,
  n.objectives = NULL,
  minimize = NULL,
  n.dim = NULL,
  lower = NULL,
  upper = NULL,
  mu = 10L,
  aspiration.set = NULL,
  normalize.fun = NULL,
  dist.fun = computeEuclideanDistance,
  p = 1,
  parent.selector = setup(selSimple),
  mutator = setup(mutPolynomial, eta = 25, p = 0.2, lower = lower, upper = upper),
  recombinator = setup(recSBX, eta = 15, p = 0.7, lower = lower, upper = upper),
  terminators = list(stopOnIters(100L))
)
}
\arguments{
\item{fitness.fun}{[\code{function}]\cr
The fitness function.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives of \code{obj.fun}.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{minimize}{[\code{logical(n.objectives)}]\cr
Logical vector with ith entry \code{TRUE} if the ith objective of \code{fitness.fun}
shall be minimized. If a single logical is passed, it is assumed to be valid
for each objective.}

\item{n.dim}{[\code{integer(1)}]\cr
Dimension of the decision space.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space in case
of float or permutation encoding.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space in case
of float or permutation encoding.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{mu}{[\code{integer(1)}]\cr
Population size. Default is 10.}

\item{aspiration.set}{[\code{matrix}]\cr
The aspiration set. Each column contains one point of the set.}

\item{normalize.fun}{[\code{function}]\cr
Function used to normalize fitness values of the individuals
before computation of the average Hausdorff distance.
The function must have the formal arguments \dQuote{set} and \dQuote{aspiration.set}.
Default is \code{NULL}, i.e., no normalization at all.}

\item{dist.fun}{[\code{function}]\cr
Distance function used internally by Hausdorff metric to compute distance
between two points. Expects a single vector of coordinate-wise differences
between points.
Default is \code{computeEuclideanDistance}.}

\item{p}{[\code{numeric(1)}]\cr
Parameter \eqn{p} for the average Hausdorff metric. Default is 1.}

\item{parent.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedure to copy individuals from a
given population to the mating pool, i. e., allow them to become parents.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}

\item{terminators}{[\code{list}]\cr
List of stopping conditions of type \dQuote{ecr_terminator}.
Default is to stop after 100 iterations.}
}
\value{
[\code{ecr_multi_objective_result}]
}
\description{
The AS-EMOA, short for aspiration set evolutionary multi-objective
algorithm aims to incorporate expert knowledge into multi-objective optimization [1].
The algorithm expects an aspiration set, i.e., a set of reference points. It
then creates an approximation of the pareto front close to the aspiration set
utilizing the average Hausdorff distance.
}
\note{
This is a pure R implementation of the AS-EMOA algorithm. It hides the regular
ecr interface and offers a more R like interface while still being quite
adaptable.
}
\references{
[1] Rudolph, G., Schuetze, S., Grimme, C., Trautmann, H: An Aspiration Set
EMOA Based on Averaged Hausdorff Distances. LION 2014: 153-156.
[2] G. Rudolph, O. Schuetze, C. Grimme, and H. Trautmann: A Multiobjective
Evolutionary Algorithm Guided by Averaged Hausdorff Distance to Aspiration
Sets, pp. 261-273 in A.-A. Tantar et al. (eds.): Proceedings of EVOLVE - A
bridge between Probability, Set Oriented Numerics and Evolutionary Computation
V, Springer: Berlin Heidelberg 2014.
}
\keyword{optimize}
