% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.dataprocessing.R
\name{categorize}
\alias{categorize}
\title{Assign group membership based on another group membership.}
\usage{
categorize(df, col, categories, cat.col, keep = TRUE, overwrite = FALSE)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data frame.}

\item{col}{[\code{character(1)}]\cr
Column name of group variable.}

\item{categories}{[\code{list}]\cr
Named list. Names indicate the name of the category while the values are character vectors
of values within the range of the \code{col} column.}

\item{cat.col}{[\code{character(1)}]\cr
Column name for categorization.}

\item{keep}{[\code{logical(1)}]\cr
Keep the source column \code{col}?
Default is \code{TRUE}.}

\item{overwrite}{[\code{logical(1)}]\cr
If \code{TRUE}, \code{cat.col} is set to \code{col}.}
}
\value{
[\code{data.frame}]
df = data.frame(
  group = c("A1", "A1", "A2", "A2", "B1", "B2"),
  perf = runif(6),
  stringsAsFactors = FALSE)
df2 = categorize(df, col = "group", categories = list(A = c("A1", "A2"), B = c("B1", "B2")), cat.col = "group2")
}
\description{
Given a data frame and a grouping column of type factor or character this function
generates a new grouping column which groups the groups.
}
