% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeIndicators.R
\name{computeIndicators}
\alias{computeIndicators}
\title{Computation of EMOA performance indicators.}
\usage{
computeIndicators(
  df,
  obj.cols = c("f1", "f2"),
  unary.inds = NULL,
  binary.inds = NULL,
  normalize = FALSE,
  offset = 0,
  ref.points = NULL,
  ref.sets = NULL
)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data frame with columns \code{obj.cols}, \dQuote{prob}, \dQuote{algorithm}
and \dQuote{repl}.}

\item{obj.cols}{[\code{character(>= 2)}]\cr
Column names of the objective functions.
Default is \code{c("f1", "f2")}, i.e., the bi-objective case is assumed.}

\item{unary.inds}{[\code{list}]\cr
Named list of unary indicators which shall be calculated.
Each component must be another list with mandatory argument \code{fun} (the
function which calculates the indicator) and optional argument \code{pars} (a named
list of parameters for \code{fun}). Function \code{fun} must have the
signiture \dQuote{function(points, arg1, ..., argk, ...)}.
The arguments \dQuote{points} and \dQuote{...} are mandatory, the remaining are
optional.
The names of the components on the first level are used for the column names
of the output data.frame.
Default is \code{list(HV = list(fun = computeHV))}, i.e., the dominated
Hypervolume indicator.}

\item{binary.inds}{[\code{list}]\cr
Named list of binary indicators which shall be applied for each algorithm
combination. Parameter \code{binary.inds} needs the same structure as \code{unary.inds}.
However, the function signature of \code{fun} is slighly different:
\dQuote{function(points1, points2, arg1, ..., argk, ...)}.
See function \code{\link{emoaIndEps}} for an example.
Default is \code{list(EPS = list(fun = emoaIndEps))}.}

\item{normalize}{[\code{logical(1)}]\cr
Normalize approximation sets to \eqn{[0, 1]^p} where \eqn{p} is the number of
objectives? Normalization is done on the union of all approximation sets for each
problem.
Default is \code{FALSE}.}

\item{offset}{[\code{numeric(1)}]\cr
Offset added to reference point estimations.
Default is 0.}

\item{ref.points}{[\code{list}]\cr
Named list of numeric vectors (the reference points). The names must be the
unique problem names in \code{df$prob} or a subset of these.
If \code{NULL} (the default), reference points are estimated from the
approximation sets for each problem.}

\item{ref.sets}{[\code{list}]\cr
Named list matrizes (the reference sets). The names must be the
unique problem names in \code{df$prob} or a subset of these.
If \code{NULL} (the default), reference points are estimated from the
approximation sets for each problem.}
}
\value{
[\code{list}] List with components \dQuote{unary} (data frame of
  unary indicators), \dQuote{binary} (list of matrizes of binary indicators),
  \dQuote{ref.points} (list of reference points used) and \dQuote{ref.sets}
  (reference sets used).
}
\description{
Given a data.frame of Pareto-front approximations for different
sets of problems, algorithms and replications, the function computes sets
of unary and binary EMOA performance indicators.
This function makes use of \code{\link[parallelMap]{parallelMap}} to
parallelize the computation of indicators.
}
\references{
[1] Knowles, J., Thiele, L., & Zitzler, E. (2006). A Tutorial on the Performance Assessment
of Stochastic Multiobjective Optimizers. Retrieved from https://sop.tik.ee.ethz.ch/KTZ2005a.pdf
[2] Knowles, J., & Corne, D. (2002). On Metrics for Comparing Non-Dominated Sets.
In Proceedings of the 2002 Congress on Evolutionary Computation Conference (CEC02)
(pp. 711–716). Honolulu, HI, USA: Institute of Electrical and Electronics Engineers.
[3] Okabe, T., Yaochu, Y., & Sendhoff, B. (2003). A Critical Survey of Performance
Indices for Multi-Objective Optimisation. In Proceedings of the 2003 Congress on Evolutionary
Computation Conference (CEC03) (pp. 878–885). Canberra, ACT, Australia: IEEE.
}
