% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr.R
\name{ecr}
\alias{ecr}
\title{Interface to ecr similar to the optim function.}
\usage{
ecr(
  fitness.fun,
  minimize = NULL,
  n.objectives = NULL,
  n.dim = NULL,
  lower = NULL,
  upper = NULL,
  n.bits,
  representation,
  mu,
  lambda,
  perm = NULL,
  p.recomb = 0.7,
  p.mut = 0.3,
  survival.strategy = "plus",
  n.elite = 0L,
  log.stats = list(fitness = list("min", "mean", "max")),
  log.pop = FALSE,
  monitor = NULL,
  initial.solutions = NULL,
  parent.selector = NULL,
  survival.selector = NULL,
  mutator = NULL,
  recombinator = NULL,
  terminators = list(stopOnIters(100L)),
  ...
)
}
\arguments{
\item{fitness.fun}{[\code{function}]\cr
The fitness function.}

\item{minimize}{[\code{logical(n.objectives)}]\cr
Logical vector with ith entry \code{TRUE} if the ith objective of \code{fitness.fun}
shall be minimized. If a single logical is passed, it is assumed to be valid
for each objective.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives of \code{obj.fun}.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{n.dim}{[\code{integer(1)}]\cr
Dimension of the decision space.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space in case
of float or permutation encoding.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space in case
of float or permutation encoding.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{n.bits}{[\code{integer(1)}]\cr
Number of bits to use for binary representation.}

\item{representation}{[\code{character(1)}]\cr
Genotype representation of the parameters. Available are \dQuote{binary},
\dQuote{float}, \dQuote{permutation} and \dQuote{custom}.}

\item{mu}{[\code{integer(1)}]\cr
Number of individuals in the population.}

\item{lambda}{[\code{integer(1)}]\cr
Number of individuals generated in each generation.}

\item{perm}{[\code{integer(1)} | \code{vector}]\cr
Either a single integer number. In this case the set is assumed to be \code{1:perm}.
Alternatively, a set, i.e., a vector of elements can be passed which should form each
individual.}

\item{p.recomb}{[\code{numeric(1)}]\cr
Probability of two parents to perform crossover.
Default is 0.7.}

\item{p.mut}{[\code{numeric(1)}]\cr
The probability that the mutation operator will be applied to a child. 
Refers only to the application of the mutation operator, not to the 
probability of mutating individual genes of the respective child.
Default is 0.1.}

\item{survival.strategy}{[\code{character(1)}]\cr
Determines the survival strategy used by the EA. Possible are \dQuote{plus} for
a classical (mu + lambda) strategy and \dQuote{comma} for (mu, lambda).
Default is \dQuote{plus}.}

\item{n.elite}{[\code{integer(1)}]\cr
Number of fittest individuals of the current generation that shall be copied to the
next generation without changing. Keep in mind, that the algorithm
does not care about this option if the \code{survival.strategy} is set to 'plus'.
Default is 0.}

\item{log.stats}{[\code{list}]\cr
(Named) list of scalar functions to compute statistics on the fitness values
in each generation. See \code{\link{initLogger}} for more information.
Default is to log fitness minimum, mean and maximum values.}

\item{log.pop}{[\code{logical(1)}]\cr
Shall the entire population be saved in each generation?
Default is \code{FALSE}.}

\item{monitor}{[\code{function}]\cr
Monitoring function.
Default is \code{NULL}, i.e. no monitoring.}

\item{initial.solutions}{[\code{list}]\cr
List of individuals which should be placed in the initial population.
If the number of passed individuals
is lower than \code{mu}, the population will be filled up
by individuals generated by the corresponding generator.
Default is \code{NULL}, i.e., the entire population is generated by the
population generator.}

\item{parent.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedure to copy individuals from a
given population to the mating pool, i. e., allow them to become parents.}

\item{survival.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedurce to extract individuals from
a given set, which should survive and set up the next generation.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}

\item{terminators}{[\code{list}]\cr
List of stopping conditions of type \dQuote{ecr_terminator}.
Default is to stop after 100 iterations.}

\item{...}{[any]\cr
Further arguments passed down to \code{fitness.fun}.}
}
\value{
[\code{\link{ecr_result}}]
}
\description{
The most flexible way to setup evolutionary algorithms with ecr is by
explicitely writing the evolutionary loop utilizing various ecr utlity functions.
However, in everyday life R users frequently need to optimize a single-objective R function.
The \code{ecr} function thus provides a more R like interface for single
objective optimization similar to the interface of the \code{\link[stats]{optim}}
function.
}
\examples{
fn = function(x) {
   sum(x^2)
}
lower = c(-5, -5); upper = c(5, 5)
res = ecr(fn, n.dim = 2L, n.objectives = 1L, lower = lower, upper = lower,
 representation = "float", mu = 20L, lambda = 10L,
  mutator = setup(mutGauss, lower = lower, upper = upper))
}
\keyword{optimize}
