% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize approximations set(s).}
\usage{
normalize(x, obj.cols, min.value = NULL, max.value = NULL, offset = NULL)
}
\arguments{
\item{x}{[\code{matrix} | \code{data.frame}]\cr
Either a numeric \code{matrix} (each column corresponds to a point) or a
\code{data.frame} with columns at least \code{obj.cols}.}

\item{obj.cols}{[\code{character(>= 2)}]\cr
Column names of the objective functions.}

\item{min.value}{[\code{numeric}]\cr
Vector of minimal values of length \code{nrow(x)}.
Only relevant if \code{x} is a matrix.
Default is the row-wise minimum of \code{x}.}

\item{max.value}{[\code{numeric}]\cr
Vector of maximal values of length \code{nrow(x)}.
Only relevant if \code{x} is a matrix.
Default is the row-wise maximum of \code{x}.}

\item{offset}{[\code{numeric}]\cr
Numeric constant added to each normalized element.
Useful to make all objectives strictly positive, e.g., located in \eqn{[1,2]}.}
}
\value{
[\code{matrix} | \code{data.frame}]
}
\description{
Normalization is done by subtracting the \code{min.value} for each dimension
and dividing by the difference \code{max.value - min.value} for each dimension
Certain EMOA indicators require all elements to be strictly positive. Hence, an optional
\code{offset} is added to each element which defaults to zero.
}
\note{
In case a data.frame is passed and a \dQuote{prob} column exists, normalization
is performed for each unique element of the \dQuote{prob} column independently (if
existent).
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{approximateRefSets}()},
\code{\link{computeDominanceRanking}()},
\code{\link{emoaIndEps}()},
\code{\link{makeEMOAIndicator}()},
\code{\link{niceCellFormater}()},
\code{\link{plotDistribution}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{plotScatter3d}()},
\code{\link{toLatex}()}
}
\concept{EMOA performance assessment tools}
