% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{replace}
\alias{replace}
\alias{replaceMuPlusLambda}
\alias{replaceMuCommaLambda}
\title{(mu + lambda) selection}
\usage{
replaceMuPlusLambda(
  control,
  population,
  offspring,
  fitness = NULL,
  fitness.offspring = NULL
)

replaceMuCommaLambda(
  control,
  population,
  offspring,
  fitness = NULL,
  fitness.offspring = NULL,
  n.elite = base::max(ceiling(length(population) * 0.1), 1L)
)
}
\arguments{
\item{control}{[\code{ecr_control}]\cr
Control object.}

\item{population}{[\code{list}]\cr
Current set of individuals.}

\item{offspring}{[\code{list}]\cr
Another set of individuals.}

\item{fitness}{[\code{matrix}]\cr
Matrix of fitness values for the individuals from \code{population}.
This is only optional in the case that each individual in \code{population} has
an attribute \dQuote{fitness}.}

\item{fitness.offspring}{[\code{matrix}]\cr
Matrix of fitness values for the individuals from \code{offspring}.
This is only optional in the case that each individual in \code{offspring} has
an attribute \dQuote{fitness}.}

\item{n.elite}{[\code{integer(1)}]\cr
Number of fittest individuals of the current generation that shall be copied to the
next generation without changing. Keep in mind, that the algorithm
does not care about this option if the \code{survival.strategy} is set to 'plus'.
Default is 0.}
}
\value{
[\code{list}] List with selected population and corresponding fitness matrix.
}
\description{
Takes a population of mu individuals and another set of lambda
offspring individuals and selects mu individuals out of the union set according
to the survival selection strategy stored in the control object.
}
