% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.selector.nondom.R
\name{selNondom}
\alias{selNondom}
\title{Non-dominated sorting selector.}
\usage{
selNondom(fitness, n.select)
}
\arguments{
\item{fitness}{[\code{matrix}]\cr
Matrix of fitness values (each column contains the fitness value(s) of one
individual).}

\item{n.select}{[\code{integer(1)}]\cr
Number of elements to select.}
}
\value{
[\code{setOfIndividuals}]
}
\description{
Applies non-dominated sorting of the objective vectors and subsequent crowding
distance computation to select a subset of individuals. This is the selector used
by the famous NSGA-II EMOA (see \code{\link{nsga2}}).
}
\seealso{
Other selectors: 
\code{\link{selDomHV}()},
\code{\link{selGreedy}()},
\code{\link{selRanking}()},
\code{\link{selRoulette}()},
\code{\link{selSimple}()},
\code{\link{selTournament}()}
}
\concept{selectors}
