% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_insurance_search.R
\name{variable_insurance_search}
\alias{variable_insurance_search}
\alias{variable_insurance_fast_search}
\title{SEC Variable Insurance Search}
\usage{
variable_insurance_search(term)

variable_insurance_fast_search(identifier)
}
\arguments{
\item{term}{Search term to search for in a company, fund or contract name}

\item{identifier}{A Series, Class/Contract ID, Ticker Symbol or CIK}
}
\value{
A dataframe of products found including the following columns -
  \itemize{
    \item class_id
    \item class_filings_href
    \item class_name
    \item class_ticker
    \item series_id
    \item series_filings_href
    \item series_name
    \item series_funds_href
    \item cik
    \item cik_name
    \item cik_filings_href
    \item cik_funds_href
  }
}
\description{
Provides access to the results of the SEC's Variable Insurance Product
search tool available
\href{https://www.sec.gov/edgar/searchedgar/vinsurancesearch.html}{here}
}
\section{Functions}{
\itemize{
\item \code{variable_insurance_fast_search}: Performs a 'Fast Search' based on an identifier
}}

\examples{
\donttest{
  try(variable_insurance_search("precious metals"))
  try(variable_insurance_fast_search("VMFVX"))
}
}
