% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundle_stub.R
\name{edge_bundle_stub}
\alias{edge_bundle_stub}
\title{stub edge bundling}
\usage{
edge_bundle_stub(
  object,
  xy,
  alpha = 11,
  beta = 75,
  gamma = 40,
  t = 0.5,
  tshift = 0.5
)
}
\arguments{
\item{object}{a graph object (igraph/tbl_graph). Does not support network objects}

\item{xy}{coordinates of vertices}

\item{alpha}{maximal angle (in degree) between consecutive edges in a bundle}

\item{beta}{angle (in degree) at which to connect two stubs}

\item{gamma}{maximal overall angle (in degree) of an edge bundle}

\item{t}{numeric between 0 and 1. control point location}

\item{tshift}{numeric between 0 and 1. The closer to one, the longer the bigger bundle}
}
\value{
data.frame containing the bundled edges
}
\description{
Implements the stub edge bundling by Nocaj and Brandes
}
\details{
see \href{https://github.com/schochastics/edgebundle}{online} for plotting tips
}
\examples{
library(igraph)
g <- graph.star(10, "undirected")

xy <- matrix(c(
    0, 0,
    cos(90 * pi / 180), sin(90 * pi / 180),
    cos(80 * pi / 180), sin(80 * pi / 180),
    cos(70 * pi / 180), sin(70 * pi / 180),
    cos(330 * pi / 180), sin(330 * pi / 180),
    cos(320 * pi / 180), sin(320 * pi / 180),
    cos(310 * pi / 180), sin(310 * pi / 180),
    cos(210 * pi / 180), sin(210 * pi / 180),
    cos(200 * pi / 180), sin(200 * pi / 180),
    cos(190 * pi / 180), sin(190 * pi / 180)
), ncol = 2, byrow = TRUE)

edge_bundle_stub(g, xy)
# use ggforce::geom_bezier for plotting
}
\references{
Nocaj, Arlind, and Ulrik Brandes. "Stub bundling and confluent spirals for geographic networks." International Symposium on Graph Drawing. Springer, Cham, 2013.
}
\seealso{
\link{edge_bundle_hammer},\link{edge_bundle_force}, \link{edge_bundle_path}
}
\author{
David Schoch
}
