% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adult_coefs.R
\docType{data}
\name{adult_enroll_dur}
\alias{adult_enroll_dur}
\title{Adult Enrollment Duration Factors - Table 9}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
11 rows and 7 columns
\describe{
\item{used}{Whether or not the category is used in the RA model}
\item{plat, gold, silver, bronze, cat}{Enrollment duration risk score for
each metal level}
\item{months}{Number of enrollment months for each risk score}
}
}
\source{
Data import and cleaning at:
\url{https://github.com/EeethB/edgedata/tree/main/data-raw}
}
\usage{
adult_enroll_dur
}
\description{
A dataset containing the adult model enrollment duration factors for the
risk adjustment model. Risk score is increased for members with less than
12 months' duration due to risk that is present but not accounted for in
diagnoses and prescriptions during the enrollment window.
}
\seealso{
Other factors: 
\code{\link{adult_demo}},
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{adult_rxc}},
\code{\link{child_demo}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{infant_demo}},
\code{\link{infant_mat_sev}}
}
\concept{factors}
\keyword{datasets}
