% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrs.R
\name{set_attrs}
\alias{set_attrs}
\title{Set the experimental context as metadata}
\usage{
set_attrs(.edibble = design(), ...)
}
\arguments{
\item{.edibble}{An edibble table or design.}

\item{...}{A series of name-value pairs where the name corresponds to the
name of the metadata nad the value corresponds to the actual metadata value.
If the name is omitted, then no name to the metadata is assigned for the
corresponding value.}
}
\description{
These are structured information that can be encoded in into the design
object. By encoding this information, you can make it interoperable.
If you use \code{\link[=export_design]{export_design()}}, the information is exported to the title sheet
of the excel output.
}
\examples{
des <- set_attrs(design(aim = "Testing for new flu vaccine.",
                        contact = "emi.tanaka (at) anu.edu",
                       "Funded by Better Experiments Institute.") )

des$context

}
