% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{rescale_continuous}
\alias{rescale_continuous}
\title{Rescale continuous covariates as appropriate for edstan models}
\usage{
rescale_continuous(x)
}
\arguments{
\item{x}{A numeric vector, matrix, or data frame}
}
\value{
A numeric vector, matrix, or data frame with rescaled covariates
  having mean of zero and standard deviation of 0.5.
}
\description{
This function scales a covariate to have a mean of zero and standard
deviation of 0.5.
}
\examples{
vec <- rnorm(5, 100, 20)
rescale_continuous(vec)

mat <- matrix(rnorm(5*5, 100, 20), ncol = 5)
rescale_continuous(mat)
}
