% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtBayes.R
\name{crtBayes}
\alias{crtBayes}
\title{Bayesian analysis of Cluster Randomised Education Trials (CRT) using Vague Priors.}
\usage{
crtBayes(
  formula,
  random,
  intervention,
  baseln,
  nsim = 10000,
  data,
  alpha = 0.05,
  digits = 3,
  threshold = c(0, 0.05, seq(0.1, 1, 0.1)),
  condopt,
  uncopt,
  ...
)
}
\arguments{
\item{formula}{The model to be analysed. It should be of the form y ~ x1 + x2 + ..., where y is the outcome variable and Xs are the predictors.}

\item{random}{A string specifying the "clustering variable" (e.g., schools or sites) as found in the dataset.}

\item{intervention}{A string specifying the "intervention variable" as it appears in the formula.}

\item{baseln}{A string specifying the reference category for the intervention variable. If not provided, the first level will be used as the reference (e.g., baseln = "0" for an intervention with levels 0 and 1).}

\item{nsim}{Number of MCMC iterations to be performed. A minimum of 10,000 is recommended to ensure convergence.}

\item{data}{A data frame containing the variables referenced in the formula, including predictors, the clustering variable, and the intervention.}

\item{alpha}{significant level, default alpha = 0.05.}

\item{digits}{number of decimal places, by default digits=3}

\item{threshold}{a scalar or vector of pre-specified threshold(s) for estimating Bayesian posterior probability such that the observed effect size is greater than or equal to the threshold(s).}

\item{condopt}{additional arguments of \code{\link[R2jags]{jags}} to be passed exclusively to the conditional model (e.g., defining n.chains only for the conditional model, etc.).}

\item{uncopt}{additional arguments of \code{\link[R2jags]{jags}} to be passed exclusively to the unconditional model (e.g., defining n.chains only for the unconditional model, etc.).}

\item{...}{Common additional arguments of \code{\link[R2jags]{jags}} to be passed to both the conditional and unconditional model specifications}
}
\value{
S3 object; a list consisting of:
\itemize{
\item \code{Beta}: Estimates and credible intervals for the predictors specified in the model (posterior distributions).
\item \code{ES}: Hedges' g effect size for the intervention(s). If bootstrapping is not used, 95\% credible intervals are computed based on MCMC sampling.
\item \code{covParm}: Variance components broken down into between-cluster variance (e.g., between schools), within-cluster variance (e.g., within pupils), and intra-cluster correlation (ICC)..
\item \code{SchEffects}: A vector of the estimated deviation of each school from the intercept.
\item \code{ProbES}: A matrix showing the probability of observing an effect size larger than various thresholds (0, 0.05, 0.10, ...).
\item \code{Model}: A model object from \code{\link[R2jags]{jags}} and an \code{\link[MCMCvis]{MCMCsummary}} object containing only the mean and credible intervals (CIs) as columns.
\item \code{Unconditional}: A list containing the unconditional effect size and variance decomposition.
}
}
\description{
\code{crtBayes} performs Bayesian multilevel analysis of cluster randomised education trials, utilising vague priors
and JAGS language to fit the model. It assumes hierarchical clustering, such as students within schools, and estimates
treatment effects while accounting for this structure.
}
\details{
The function provides posterior estimates for fixed effects (predictors) and random effects (clustering) under a Bayesian framework.
Effect sizes are computed using Hedges' g, and variance components are decomposed into between-cluster and within-cluster variances.
}
\examples{
if(interactive()){

  data(crtData)

  ########################################################
  ## Bayesian analysis of cluster randomised trials     ##
  ########################################################

  output <- crtBayes(formula = Posttest ~ Prettest + Intervention,
                     random = "School",
                     intervention = "Intervention",
                     alpha = 0.05,
                     digits = 3,
                     nsim = 10000,
                     data = crtData)
  output

  ### Fixed effects
  beta <- output$Beta
  beta

  ### Effect size
  ES1 <- output$ES
  ES1

  ## Covariance matrix
  covParm <- output$covParm
  covParm

  ## Prob ES
  ProbES <- output$ProbES
  ProbES

  ## Unconditional
  Unconditional <- output$Unconditional
  Unconditional


  ### plot random effects for schools

  plot(output)

  ### plot posterior probability of an effect size to be bigger than a pre-specified threshold

  plot(output,group=1)


}

}
