% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{calendar_plot}
\alias{calendar_plot}
\title{Create calendar plot}
\usage{
calendar_plot(df, type = "continuous", labels = NULL,
  legend_name = "Exposure")
}
\arguments{
\item{df}{Data frame with one column named \code{date} for date with entries in the format
"yyyy-mm-dd" and one column for the daily values of the variable to plot.}

\item{type}{Character string specifying whether the exposure is continuous or
discrete}

\item{labels}{Vector of character strings naming the levels of a discrete
variable to be used in the figure legend.}

\item{legend_name}{Character string specifying the title to be used in the figure
legend.}
}
\description{
Creates a calendar plot of a time series of continuous or discrete data. The time series
data frame input to this function must have only two columns, one for the date and one with
the values to plot.
}
\details{
The output of this function is a \code{ggplot} object, so you can customize
   this output object as with any \code{ggplot} object.
}
\examples{
testdat <- sim_exposure(n = 1000, central = 0.1,
           exposure_type = "binary")
testdat$x[c(89,101,367,500,502,598,678,700,895)] <- 3
calendar_plot(testdat, type = "discrete", labels = c("no", "yes", "maybe"))

}
