% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_models.R
\name{spline_mod}
\alias{spline_mod}
\title{Fit a generalized linear model}
\usage{
spline_mod(df, df_year = 7)
}
\arguments{
\item{df}{A data frame with columns for daily exposure and outcome called "x" and "outcome",
respectively}

\item{df_year}{A numeric value specifying the degrees of freedom per year to
use in the spline to control for long-term and seasonal trends in the outcome.}
}
\value{
A numeric vector of length six with summary measures from fitting this model
   to simulated data.
}
\description{
Fits a model to estimate the log relative risk between an exposure and outcome
by using a natural cubic spline to control for long-term and seasonal trends and
assuming a quasi-Poisson distribution for the outcome. This function provides an
example of a function that can be input to \code{\link{eesim}} or \code{\link{power_calc}}.
}
\examples{
exp <- sim_exposure(n = 500, central = 100, sd = 10, trend = "cos1",
                    amp = .6, exposure_type = "continuous")
out <- sim_outcome(exposure = exp, average_outcome = 22, rr = 1.01)
spline_mod(df = out)

}
