% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overdispersion.R
\name{overdispersion}
\alias{overdispersion}
\title{Estimating overdispersion}
\usage{
overdispersion(
  data,
  siteID,
  visitID,
  count = "count",
  pass = "pass",
  lifestage = "lifestage",
  pass12 = "pass12",
  id,
  largemodel
)
}
\arguments{
\item{data}{dataframe containing EF data}

\item{siteID}{site name or unique ID}

\item{visitID}{a number identifying each unique visit}

\item{count}{count of fish (defaults to "count")}

\item{pass}{the EF pass number (defaults to "pass")}

\item{lifestage}{the lifestage (defaults to "lifestage")}

\item{pass12}{categorical variable with 2 levels where the 1st pass
and subsequent passes are treated separately (defaults to "pass12")}

\item{id}{sample ID}

\item{largemodel}{the large model that captures most of the systematic
variation in the data - this is specified before
running the overdispersion function}
}
\value{
a data.frame summarising overdispersion
}
\description{
Complete function for returning overdispersion estimates
}
\note{
ensure column names in function call are in inverted commas
}
