% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_igraph_network.R
\name{as_igraph}
\alias{as_igraph}
\alias{as.igraph.egor}
\alias{as_network}
\alias{as.network.egor}
\title{Convert \code{egor} object to \code{network} or \code{igraph} objects}
\usage{
as_igraph(
  x,
  directed = FALSE,
  include.ego = FALSE,
  ego.attrs = NULL,
  ego.alter.weights = NULL,
  graph.attrs = ".egoID"
)

\method{as.igraph}{egor}(
  x,
  directed = FALSE,
  include.ego = FALSE,
  ego.attrs = NULL,
  ego.alter.weights = NULL,
  graph.attrs = ".egoID"
)

as_network(
  x,
  directed = FALSE,
  include.ego = FALSE,
  ego.attrs = NULL,
  ego.alter.weights = NULL,
  graph.attrs = ".egoID"
)

\method{as.network}{egor}(
  x,
  directed = FALSE,
  include.ego = FALSE,
  ego.attrs = NULL,
  ego.alter.weights = NULL,
  graph.attrs = ".egoID"
)
}
\arguments{
\item{x}{An \code{egor} object.}

\item{directed}{Logical, indicating if alter-alter relations are directed.}

\item{include.ego}{\code{Logical.} Should ego be included?}

\item{ego.attrs}{Vector of names (character) or indices (numeric) of ego
variables that should be carried over to  the network/
igraph objects. This is ignored, when \code{include.ego = FALSE} (default).}

\item{ego.alter.weights}{Vector of names (character) or indices (numeric) of
alter variables that should be carried over to the the
network/ igraph objects, as edge attributes of the ego-alter relations.
This is ignored, when `include.ego = FALSE`` (default).}

\item{graph.attrs}{Vector of names (character) or indices (numeric) of
ego variables that are supposed to be carried over to the igraph object
as graph attributes or the network object as network attributes. By
default \code{.egoID} is carried over.}
}
\description{
These functions convert an \code{egor} object into a list of \code{network} or \code{igraph} objects.
By default ego itself is not included in the created objects, there is
a parameter (\strong{include.egor}) that allows for including ego.
}
\details{
The names of the variables specified in ego.attr and ego.alter.attr
need to be the same as the names of corresponding alter attributes,
in order for those variables to be merged successfully in the resulting
network/ igraph object (see example).
}
\examples{
e <- make_egor(3, 22)
as_igraph(e)
}
