% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{as_tibble.egor}
\alias{as_tibble.egor}
\alias{as_survey.egor}
\alias{as_egos_df}
\alias{as_alters_df}
\alias{as_aaties_df}
\alias{as_egos_survey}
\alias{as_alters_survey}
\alias{as_aaties_survey}
\title{Extract ego, alter, and alter-alter tables from an \code{egor} object.}
\usage{
\method{as_tibble}{egor}(x, ..., include.ego.vars = FALSE, include.alter.vars = FALSE)

\method{as_survey}{egor}(.data, ..., include.ego.vars = FALSE, include.alter.vars = FALSE)

as_egos_df(object)

as_alters_df(object, include.ego.vars = FALSE)

as_aaties_df(object, include.ego.vars = FALSE, include.alter.vars = FALSE)

as_egos_survey(object, include.ego.vars = FALSE)

as_alters_survey(object, include.ego.vars = FALSE)

as_aaties_survey(object, include.ego.vars = FALSE, include.alter.vars = FALSE)
}
\arguments{
\item{x, object, .data}{An \code{egor} object.}

\item{...}{Additional arguments, currently unused.}

\item{include.ego.vars}{Logical, specifying if ego variables should be included in the result.}

\item{include.alter.vars}{Logical, specifying if alter variables should be included in the result.}
}
\value{
A \code{tibble} for the \code{as_tibble} and \verb{*_df} functions and a \code{tbl_svy} for \code{as_survey} and the \verb{*_survey} functions.
}
\description{
Provided an \code{egor} object, these functions create a "global" \code{tibble} or \code{srvyr}'s \code{\link[srvyr:tbl_svy]{srvyr::tbl_svy}} object
containing egos, alter attributes, or alter-alter relations. The resulting tables
are useful for advanced analysis procedures, e.g. multi-level regressions.

\code{\link[tibble:as_tibble]{tibble::as_tibble()}} method for \code{egor} extracts the currently active component (\code{ego}, \code{alter}, or \code{aaties}) table, optionally joining it with the others, dropping any survey design information.

\code{\link[srvyr:as_survey]{srvyr::as_survey()}} method for \code{egor} instead returns a \code{srvyr} \code{\link[srvyr:tbl_svy]{srvyr::tbl_svy}} survey, taking into account any replication due to multiple alters or alter-alter ties incident on each ego. If no design is specified for the egos, then the default design (simple random sample with replacement) is assumed as the starting point.

\code{as_egos_df()}, \code{as_alters_df()}, \code{as_aaties_df()}, \code{as_egos_survey()}, \code{as_alters_survey()}, and \code{as_aaties_survey()} are convenience functions for the \code{as_tibble()} and \code{as_survey()} methods, activating the corresponding component of the \code{egor} object.
}
\examples{
# Load example data
data(egor32)

as_tibble(egor32) # Ego table.

egor32 \%>\%
 activate("alter") \%>\%
 as_tibble(include.ego.vars=TRUE) # Alter table, but also with ego variables.

library(srvyr)
as_survey(egor32) # Ego table with survey design.

# Despite alter table being active, obtain the ego table.
(egor32 <- activate(egor32, "alter"))
as_egos_df(egor32)

# Create global alter table
as_alters_df(egor32)

# Create global alter-alter relations table
as_aaties_df(egor32)

# ... adding alter variables
as_aaties_df(egor32, include.alter.vars = TRUE)
as_egos_survey(egor32)
as_alters_survey(egor32) # Notice the resulting cluster design.
}
