% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{clustering_validation}
\alias{clustering_validation}
\title{Create a table containing four validation metrics for clustering: Purity, F-measure
and Rand Index (RI) and Adjusted Rand Index (ARI). This function considers pairs of points}
\usage{
clustering_validation(clusters, true_labels, digits = 4)
}
\arguments{
\item{clusters}{The clusters predicted by the clustering method.}

\item{true_labels}{Atomic vector with the true labels of the data.}

\item{digits}{Number of digits for rounding.}
}
\value{
A \code{list} containing values for Purity, F-measure, RI and ARI.
}
\description{
Create a table containing four validation metrics for clustering: Purity, F-measure
and Rand Index (RI) and Adjusted Rand Index (ARI). This function considers pairs of points
}
\examples{
set.seed(1221)
vars <- list(c("dtaEI", "dtaMEI"))
data <- sim_model_ex1()
true_labels <- c(rep(1, 50), rep(2, 50))
data_ind <- generate_indices(data)
clus_kmeans <- clustInd_kmeans(data_ind, vars)
cluskmeans_mahalanobis_dtaEIdtaMEI <- clus_kmeans$kmeans_mahalanobis_dtaEIdtaMEI$cluster
clustering_validation(cluskmeans_mahalanobis_dtaEIdtaMEI, true_labels)

}
