% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eicm-options.r
\name{eicm.options}
\alias{eicm.options}
\title{Set EICM fitting options}
\usage{
eicm.options(...)
}
\arguments{
\item{...}{a named list of options. See details.}
}
\value{
A \code{eicm.options} object with options for model fitting, currently a model mask and model offsets.
}
\description{
Construct a EICM options object to inform the fitting engine. There is usually no need to use this function directly.
}
\details{
Possible options are currently: \code{mask} and \code{offset}. Both are lists having the same structure of an \code{eicm.matrix} object:
\describe{
  \item{$mask}{Binary matrices defining which coefficients are to be estimated in model fitting
               OR a scalar, constant for all coefficients. 0 or FALSE exclude the given term from estimation,
               i.e., fixes it at 0.
    \describe{
      \item{$mask$env}{environmental coefficient mask}
      \item{$mask$sp}{species interaction mask}
    }
  }
  \item{$offset}{Numeric matrices defining constant terms, to be fixed and not estimated
    \describe{
      \item{$offset$env}{environmental coefficient offset}
      \item{$offset$sp}{species interaction offset}
    }
  }
}
When an offset for a term is nonzero, the respective mask element will be automatically zeroed (so it is not estimated).
}
