% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/einop.R
\name{einop}
\alias{einop}
\title{Perform Einstein-style tensor operations}
\usage{
einop(
  x,
  expr,
  reduction = NULL,
  ...,
  .row_major = getOption("einops_row_major", FALSE)
)
}
\arguments{
\item{x}{tensor: array, matrix, or list of arrays of the same shape and type}

\item{expr}{string: reduction pattern}

\item{reduction}{A string specifying the reduction operation (e.g.,
"mean", "sum", "max"). Required for reduce operations, ignored for
rearrange and repeat operations.}

\item{...}{either corresponding axes lengths or a single list of them.}

\item{.row_major}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} logical: whether to
use row-major order for the output
tensor. If \code{TRUE}, the \emph{operation} is performed in row-major order, but the
output will be in whatever order the parent framework uses (e.g. column-major
for \code{\link[base:array]{base::array()}}).}
}
\value{
A tensor with dimensions transformed according to the expression
}
\description{
A unified interface for rearranging, reducing, and repeating tensor
dimensions using Einstein notation-inspired expressions. This was directly
adapted from the python \code{einop} package: https://github.com/cgarciae/einop

\code{einop()} auto detects the operation type based on the provided expression:
\itemize{
\item \code{\link[=rearrange]{rearrange()}} when all input dimensions are present in output
\item \code{\link[=reduce]{reduce()}} when some input dimensions are missing from output
\item \code{\link[=einops.repeat]{einops.repeat()}} when output contains dimensions not in input
}

Note that there are ongoing debates about the use of this function purely
from the perspective of code readability and maintainability:
\url{https://github.com/arogozhnikov/einops/issues/84}. Generally, some argue
that the descriptive names of \code{rearrange}, \code{reduce}, and \code{repeat}
encourage good practices, while others think that semantically \code{einop()}
actually makes it \emph{clearer} what the operation
is doing, as opposed to mandating the use of these commonly used function
names across many packages.
}
\examples{
if (requireNamespace("abind", quietly = TRUE)) {

# load a 3d tensor representing an rgb image
x <- get(data("einops_image"))[1, , , ]

# Rearrange dimensions
einop(x, "h w c -> c h w")

# Reduce dimensions
einop(x, "h w c -> h w", "mean")

# Repeat dimensions
einop(x[, , 1], "h w -> h w c", c = 3)

}

}
