% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_shape.R
\name{parse_shape}
\alias{parse_shape}
\title{Parse a tensor shape to dictionary mapping axes names to their lengths.}
\usage{
parse_shape(x, expr, ...)
}
\arguments{
\item{x}{tensor of any supported framework}

\item{expr}{character of length 1, space separated names for axes,
underscore means skip axis}

\item{...}{additional arguments passed to methods}
}
\value{
named list, maps axes names to their lengths
}
\description{
Use underscore to skip the dimension in parsing.
}
\examples{
if (requireNamespace("abind", quietly = TRUE)) {

# Use underscore to skip the dimension in parsing.
x <- array(0, dim = c(2, 3, 5, 7))
parse_shape(x, 'batch _ h w')

# `parse_shape` output can be used to specify axes_lengths for other
# operations:
y <- array(0, dim = 700)
shape_info <- parse_shape(x, 'b _ h w')
# rearrange(y, '(b c h w) -> b c h w', shape_info) would give shape
# (2, 10, 5, 7)

}

}
