# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name cga_generate_chromosome
#' @title Generate Chromosome
#' @description Generate a binary vector using a probability vector
#' 	This function is not directly called by user. CGAs (Compact genetic algorithms)
#' 	sample chromosomes using this probability vector. A probability vector
#' 	contains[P1, P2, ..., PN] and the function generates and returns a chromosome[B1, B2, ..., BN].
#' 	The probability of BK having the value of 1 is PK. So, it has more chance to have
#' 	[1, 1, 1, 0, 0] rather than [0, 0, 0, 1, 1] when the probability vector is
#'  	[0.9, 0.9, 0.9, 0.1, 0.1]. 
#' @param prob_vec Vector of probabilities
#' @param vect Vector of bits.
#' @return Mutates the vect. Returns null.
#' @export
cga_generate_chromosome <- function(prob_vec, vect) {
    invisible(.Call('_eive_cga_generate_chromosome', PACKAGE = 'eive', prob_vec, vect))
}

#' @name cga
#' @title Compact Genetic Algorithm
#' @description Performs a Compact Genetic Algorithm (CGA) search
#' 	for a given chromosome size, population size (mutation rate), 
#'     and an objective function. 
#' @param chsize Number of bits.
#' @param popsize Size of population. The value is used for mutating 
#'		the probability vector by 1/popsize. 
#' @param evalFunc Objective function.
#' @return Binary vector of size chsize.
#' @export
cga <- function(chsize, popsize, evalFunc) {
    .Call('_eive_cga', PACKAGE = 'eive', chsize, popsize, evalFunc)
}

