% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/electionsbr_rda.R
\name{elections_rda}
\alias{elections_rda}
\title{Download data on the candidates' background in local elections}
\usage{
elections_rda(year, level = "fed", archive = "candidate")
}
\arguments{
\item{year}{Election year. For this function, only the years of 1996, 2000, 2004, 2008, 2012, 2016, 2020, and 2024
are available for local level. 1994, 1998, 2002, 2006, 2010, 2014, 2018, and 2022 are available for the federal level.}

\item{level}{Election level podem ser fed (default) or local.}

\item{archive}{Corresponds to one the following options: \code{candidate}, to download candidates' data; 
\code{vote_mun_zone}, to download electoral results; \code{legend}, to download data on parties' labels;
\code{party_mun_zone}, to download electoral results by party; \code{personal_finances}, to download
candidates' personal finances; \code{details_mun_zone}, to download data on the verification of elections;
and \code{seats}, to download data on available seats.}
}
\description{
Download data on the candidates' background in local elections
}
\examples{
\dontrun{
df <- elections_rda(2018)
}
}
