% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seats_fed.R
\name{seats_fed}
\alias{seats_fed}
\title{Download data on the number of seats under dispute in federal elections}
\usage{
seats_fed(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE
)
}
\arguments{
\item{year}{Election year. For this function, only the years of 1998, 2002, 2006, 2010, 2014, 2018, and 2022
are available.}

\item{uf}{Federation Unit acronym (\code{character} vector).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recovers only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE} keep temporary compressed file}
}
\value{
\code{seats_fed()} returns a \code{data.frame} with the following variables:
}
\description{
\code{seats_fed()} downloads and aggregates data on the number of seats under dispute in
federal elections in Brazil. The function returns a \code{tbl, data.frame} where each observation
corresponds to a district-office dyad.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information can be incomplete.
}
\examples{
\dontrun{
df <- seats_fed(2000)
}
}
