% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KoltchinskiiSakhanenko.R
\name{KoltchinskiiSakhanenko}
\alias{KoltchinskiiSakhanenko}
\title{Koltchinskii and Sakhanenko's test for elliptical symmetry}
\usage{
KoltchinskiiSakhanenko(X, R = 1000, nJobs = -1)
}
\arguments{
\item{X}{A numeric matrix.}

\item{R}{The number of bootstrap replicates.}

\item{nJobs}{The number of CPU cores used for the calculation. The default value -1 indicates that all cores except one are used.}
}
\value{
An object of class \code{"htest"} containing the following components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{pvalue}}{The p-value of the test.}
\item{\code{alternative}}{A character string describing the alternative hypothesis.}
\item{\code{method}}{A character string indicating what type of test was performed.}
}
\description{
Test for elliptical symmetry.
}
\section{Background}{

Koltchinskii and Sakhanenko (2000) proposed a class of omnibus bootstrap tests for elliptical symmetry
that are affine invariant and consistent against any fixed alternative. This test is based on spherical harmonics.
}

\examples{

## sepal width and length of the versicolor subset of the Iris data
X = datasets::iris[51:100,1:2]

KoltchinskiiSakhanenko(X, R = 10, nJobs=2)
}
\references{
Koltchinskii, V., & Sakhanenko, L., (2000). Testing for ellipsoidal symmetry of a multivariate distribution. \emph{High Dimensional Probability II}, 493-510, Springer.

Sakhanenko, L., (2008). Testing for ellipsoidal symmetry: A comparison study. \emph{Computational Statistics & Data Analysis}, \bold{53}(2), 565-581.
}
