% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-claude.R
\name{chat_anthropic}
\alias{chat_anthropic}
\alias{chat_claude}
\alias{models_claude}
\alias{models_anthropic}
\title{Chat with an Anthropic Claude model}
\usage{
chat_anthropic(
  system_prompt = NULL,
  params = NULL,
  model = NULL,
  cache = c("5m", "1h", "none"),
  api_args = list(),
  base_url = "https://api.anthropic.com/v1",
  beta_headers = character(),
  api_key = NULL,
  credentials = NULL,
  api_headers = character(),
  echo = NULL
)

chat_claude(
  system_prompt = NULL,
  params = NULL,
  model = NULL,
  cache = c("5m", "1h", "none"),
  api_args = list(),
  base_url = "https://api.anthropic.com/v1",
  beta_headers = character(),
  api_key = NULL,
  credentials = NULL,
  api_headers = character(),
  echo = NULL
)

models_claude(
  base_url = "https://api.anthropic.com/v1",
  api_key = anthropic_key()
)

models_anthropic(
  base_url = "https://api.anthropic.com/v1",
  api_key = anthropic_key()
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{model}{The model to use for the chat (defaults to "claude-sonnet-4-5-20250929").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.
Use \code{models_anthropic()} to see all options.}

\item{cache}{How long to cache inputs? Defaults to "5m" (five minutes).
Set to "none" to disable caching or "1h" to cache for one hour.

See details below.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{base_url}{The base URL to the endpoint; the default is Claude's
public API.}

\item{beta_headers}{Optionally, a character vector of beta headers to opt-in
claude features that are still in beta.}

\item{api_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{credentials} instead.}

\item{credentials}{Override the default credentials. You generally should not need this argument; instead set the \code{ANTHROPIC_API_KEY} environment variable. The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.

If you do need additional control, this argument takes a zero-argument function that returns either a string (the API key), or a named list (added as additional headers to every request).}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://www.anthropic.com}{Anthropic} provides a number of chat based models
under the \href{https://claude.com/product/overview}{Claude} moniker. Note that a
Claude Pro membership does not give you the ability to call models via the
API; instead, you will need to sign up (and pay for) a
\href{https://platform.claude.com/}{developer account}.
}
\section{Caching}{
Caching with Claude is a bit more complicated than other providers but we
believe that on average it will save you both money and time, so we have
enabled it by default. With other providers, like OpenAI and Google,
you only pay for cache reads, which cost 10\% of the normal price. With
Claude, you also pay for cache writes, which cost 125\% of the normal price
for 5 minute caching and 200\% of the normal price for 1 hour caching.

How does this affect the total cost of a conversation? Imagine the first
turn sends 1000 input tokens and receives 200 output tokens. The second
turn must first send both the input and output from the previous turn
(1200 tokens). It then sends a further 1000 tokens and receives 200 tokens
back.

To compare the prices of these two approaches we can ignore the cost of
output tokens, because they are the same for both. How much will the input
tokens cost? If we don't use caching, we send 1000 tokens in the first turn
and 2200 (1000 + 200 + 1000) tokens in the second turn for a total of 3200
tokens. If we use caching, we'll send (the equivalent of) 1000 * 1.25 = 1250
tokens in the first turn. In the second turn, 1000 of the input tokens will
be cached so the total cost is 1000 * 0.1 + (200 + 1000) * 1.25 = 1600
tokens. That makes a total of 2850 tokens, i.e. 11\% fewer tokens,
decreasing the overall cost.

Obviously, the details will vary from conversation to conversation, but
if you have a large system prompt that you re-use many times you should
expect to see larger savings. You can see exactly how many input and
cache input tokens each turn uses, along with the total cost,
with \code{chat$get_tokens()}. If you don't see savings for your use case, you can
suppress caching with \code{cache = "none"}.

I know this is already quite complicated, but there's one final wrinkle:
Claude will only cache longer prompts, with caching requiring at least
1024-4096 tokens, depending on the model. So don't be surprised it if you
don't see any differences with caching if you have a short prompt.

See all the details at
\url{https://docs.claude.com/en/docs/build-with-claude/prompt-caching}.
}

\examples{
\dontshow{ellmer:::vcr_example_start("chat_anthropic")}
chat <- chat_anthropic()
chat$chat("Tell me three jokes about statisticians")
\dontshow{ellmer:::vcr_example_end()}
}
\seealso{
Other chatbots: 
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openai_compatible}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
