% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{plot_frequency}
\alias{plot_frequency}
\title{Plot the histogram of the approximation of the RR distribution}
\usage{
plot_frequency(
  estimated,
  sqrt = FALSE,
  binwidth = 0.1,
  hist_color = "#69b3a2",
  density_color = "#FF5733",
  xlab = "Score"
)
}
\arguments{
\item{estimated}{The ScoreDistribution element in the list 
returned by the DistributionApproximation function}

\item{sqrt}{A Boolean to specify whether we normalize the estimated or not, it is recommended on large random walk.}

\item{binwidth}{The width of the histogram bins}

\item{hist_color}{The fill color for the histogram bars}

\item{density_color}{The color for the density curve}

\item{xlab}{Label of X axis}
}
\value{
no returned value, should plot the histogram of the estimated distribution
(estimated).
}
\description{
Plot the histogram of the approximation of the RR distribution
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

estimation = DistributionApproximation(epochs = 10, ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)

plot_frequency(estimated = estimation$ScoreDistribution)
}
}
