% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestfunctions.R
\docType{data}
\name{forestfunctions}
\alias{forestfunctions}
\title{Forest Functions Dataset (forestfunctions)}
\format{
A data frame with 209 rows and 31 columns:
\describe{
  \item{plotid}{The unique identifier for each forest plot}
  \item{target_species_richness}{The planned/designed species richness of the plot}
  \item{composition}{Information about the species composition}
  \item{region_centred_ba}{Region-centered basal area}
  \item{region_centred_coniferous}{Region-centered coniferous proportion}
  \item{earthworm_biomass.std}{Biomass of all earthworms (g m-2)}
  \item{fine_woody_debris.std}{Snags and standing dead trees shorter than 1.3 m and thinner than 5 cm DBH, and all stumps and other dead wood pieces on the forest floor}
  \item{microbial_biomass_mineral.std}{Mineral soil (0-5 cm layer) microbial biomass carbon}
  \item{soil_c_ff_10.std}{Total soil carbon stock (Mg ha-1) in forest floor and 0-10 cm mineral soil layer combined}
  \item{litter_decomp_day.std}{Decomposition of leaf litter using the litterbag methodology (\% daily rate)}
  \item{nre.std}{Nitrogen resorption efficiency, difference in N content between green and senescent leaves divided by N content of green leaves (\%)}
  \item{soil_cn_ff_10.std}{Soil C/N ratio in forest floor and 0-10 cm mineral soil layer combined (smaller values are desirable)}
  \item{wood_decomp_day.std}{Decomposition of flat wooden sticks placed on forest floor (\% daily rate)}
  \item{root_biomass.std}{Total biomass of living fine roots in forest floor and 0-10 mineral soil layer combined (g m-2)}
  \item{lai.std}{Leaf area index}
  \item{leaf_litter_production.std}{Annual production of foliar litter dry mass (g)}
  \item{photo_eff_tot.std}{Chlorophyll fluorescence methodology (ChlF)}
  \item{tree_growth.std}{Annual aboveground wood production (Mg C ha-1 year-1)}
  \item{tree_biomass.std}{Aboveground biomass of all trees (Mg C ha-1)}
  \item{total_understorey_weight.std}{Dry weight of all understory vegetation in a quadrant (g)}
  \item{sapling_growth.std}{Growth of saplings up to 1.60 m tall (cm)}
  \item{regeneration_seedlings.std}{Number of tree seedlings less than a year old}
  \item{regeneration_juveniles.std}{Number of saplings up to 1.60 m tall}
  \item{wue.std}{Resistance to drought, difference in carbon isotope composition in wood cores between dry and wet years (smaller values are desirable)}
  \item{resistance_insects.std}{Foliage not damaged by insects (\%)}
  \item{lack_browsing.std}{Twigs not damaged by browsers (\%)}
  \item{no_pathogen_damage.std}{Foliage not damaged by pathogens (\%)}
  \item{tree.growth.recovery.std}{Ratio between post-drought growth and growth during the respective drought period}
  \item{tree.growth.resilience.std}{Ratio between growth after and before the drought period}
  \item{tree.growth.resistance.std}{Ratio of tree growth during a drought period and growth during the previous 5-year high-growth period}
  \item{tree.growth.stability.std}{Mean annual tree growth divided by standard deviation in annual tree growth between 1992 and 2011}
}
}
\source{
Scherer-Lorenzen, M., Allan, E., Ampoorter, E., Avacaritiei, D., Baeten, L., Barnoaiea, I. et al. (2023) The functional significance of tree species diversity in European forests—the FunDivEUROPE dataset [dataset]. Dryad Digital Repository. Available from: https://doi.org/10.5061/dryad.9ghx3ffpz
}
\usage{
forestfunctions
}
\description{
A dataset containing 26 ecosystem functions measured across the FunDivEUROPE Exploratory Platform. All functions have been preprocessed to handle missing values and normalized to a range of [0,1] within each country, with higher values indicating better ecosystem functionality (except for soil_cn_ff_10 and wue, where lower values are desirable).
}
\details{
Missing values (approximately 5\% of the data) were imputed using country-level mean values for each function.
All functions were then normalized to a range of [0,1] within each country. For most functions, higher values
indicate better ecosystem functionality, except for soil_cn_ff_10 and wue, where lower values are desirable.
}
\examples{
data(forestfunctions)
head(forestfunctions)
}
\keyword{datasets}
