% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hspec.R
\name{set_residual}
\alias{set_residual}
\alias{set_residual,hspec-method}
\title{Set Residual Distribution Functions for Hawkes Model Specification}
\usage{
set_residual(
  object,
  param,
  dresidual = NULL,
  presidual = NULL,
  qresidual = NULL,
  rresidual = NULL,
  ...
)

\S4method{set_residual}{hspec}(
  object,
  param,
  dresidual = NULL,
  presidual = NULL,
  qresidual = NULL,
  rresidual = NULL
)
}
\arguments{
\item{object}{An object of class \code{hspec} (Hawkes model specification)}

\item{param}{A named numeric vector of parameters for the residual distribution}

\item{dresidual}{Density function of the residual distribution (optional)}

\item{presidual}{Cumulative distribution function (CDF) of the residual distribution (optional)}

\item{qresidual}{Quantile function of the residual distribution (optional)}

\item{rresidual}{Random generation function of the residual distribution (optional)}

\item{...}{Additional arguments for future extensions}
}
\value{
An updated \code{hspec} object with residual functions set
}
\description{
Sets residual distribution functions (density, CDF, quantile, and random generation)
for a Hawkes model specification object with fixed parameters.
}
\details{
This method allows setting residual distribution functions for a flexible model.

The \code{param} argument in these functions defaults to the parameters provided during
setup and is used for estimation.
}
\examples{
\dontrun{
# Create basic Hawkes specification
hspec_obj <- new("hspec",
                 mu = matrix(0.1, nrow = 1),
                 alpha = matrix(0.5, nrow = 1),
                 beta = matrix(1.0, nrow = 1))

# Set residual distribution parameters
params <- c(a = 0.5, ell = 1.0)

# Apply residual functions
hspec_obj <- set_residual(
  hspec_obj,
  param = params,
  dresidual = dtzexp,
  presidual = ptzexp,
  qresidual = qtzexp,
  rresidual = rtzexp
)

# Check resulting functions
hspec_obj@dresidual
hspec_obj@rresidual
}

}
