% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.enpls.R
\name{plot.enpls.od}
\alias{plot.enpls.od}
\title{Plot enpls.od object}
\usage{
\method{plot}{enpls.od}(
  x,
  criterion = c("quantile", "sd"),
  prob = 0.05,
  sdtimes = 3L,
  alpha = 1,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{enpls.od}.}

\item{criterion}{Criterion of being classified as an outlier,
can be \code{"quantile"} or \code{"sd"}.}

\item{prob}{Quantile probability as the cut-off value.}

\item{sdtimes}{Times of standard deviation as the cut-off value.}

\item{alpha}{An alpha transparency value for points, a real number in (0, 1].}

\item{main}{Plot title.}

\item{...}{Additional graphical parameters for \code{\link{plot}}.}
}
\description{
Plot enpls.od object
}
\examples{
data("alkanes")
x <- alkanes$x
y <- alkanes$y

set.seed(42)
od <- enpls.od(x, y, reptimes = 50)
plot(od, criterion = "quantile")
plot(od, criterion = "sd")
}
\seealso{
See \code{\link{enpls.od}} for outlier detection with
ensemble partial least squares regressions.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
