% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idtax2df.R
\name{idtax2df}
\alias{idtax2df}
\title{Converts outputs of DECIPHER's idtaxa algorithm into a dataframe compatible
with the algorithms used in ensembleTax.}
\usage{
idtax2df(
  tt,
  db = "pr2",
  ranks = NULL,
  boot = 0,
  rubric = NULL,
  return.conf = FALSE
)
}
\arguments{
\item{tt}{The taxonomy table output by DECIPHER's idtaxa algorithm}

\item{db}{The database you ran idtaxa against. Either "pr2", "silva", "rdp",
or "gg" are supported.}

\item{ranks}{NULL, or a character vector of column names if db is set to NULL}

\item{boot}{The bootstrap threshold below which taxonomic assignments should
be set to NA. This can also be done with DECIPHER's idtaxa but is included
here for convenience.}

\item{rubric}{a DNAStringSet (see Biostrings package) with ASV sequences
named by your preferred ASV identifier. Both the ASV sequence and identifier
will be merged with the output dataframe. If NULL, ASV-identifying data is
not included in the output dataframe.}

\item{return.conf}{If TRUE, returns a list where the first element is your
formatted taxonomy table and the second element is a dataframe of bootstrap
confidence values. If FALSE, your formatted taxonomy table is returned as a
dataframe.}
}
\value{
a dataframe formatted for use with taxmapper and/or ensembleTax
}
\description{
Converts outputs of DECIPHER's idtaxa algorithm into a dataframe compatible
with the algorithms used in ensembleTax.
}
\details{
For consistency with DADA2's assignTaxonomy function, when used with
Silva, RDP, or GreenGenes it subsamples the ranks c("domain", "phylum",
"class", "order", "family", "genus"). Set db = NULL and supply ranks for
databases that aren't directly supported. The output taxonomy table is sorted
by the ASV-identifying data supplied in the rubric.

CAUTION: the idtaxa algorithm does not return any ASV-identifying data in its
output "taxon" object. The elements of tt should thus be supplied in the same
order as the elements in rubric. This will typically be the case so long as
there is no tampering with the rubric or taxon object in between implementing
idtaxa and their use here.
}
\examples{
data("idtax.pr2.sample")
data("rubric.sample")
head(idtax.pr2.sample)
head(rubric.sample)
df <- idtax2df(tt = idtax.pr2.sample, db = "pr2", ranks = NULL, boot = 0,
rubric = NULL, return.conf = FALSE)
head(df)
df <- idtax2df(tt = idtax.pr2.sample, db = "pr2", ranks = NULL, boot = 0,
rubric = rubric.sample, return.conf = FALSE)
head(df)
df <- idtax2df(tt = idtax.pr2.sample, db = "pr2", ranks = NULL, boot = 60,
rubric = rubric.sample, return.conf = FALSE)
head(df)
df <- idtax2df(tt = idtax.pr2.sample, db = "pr2", ranks = NULL, boot = 60,
rubric = rubric.sample, return.conf = TRUE)
head(df)

}
\seealso{
bayestax2df, ensembleTax, taxmapper
}
\author{
Dylan Catlett

Connie Liang
}
