% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{read_path}
\alias{read_path}
\title{Read path}
\usage{
read_path(
  lib,
  filename,
  full.path = TRUE,
  envsetup_environ = Sys.getenv("ENVSETUP_ENVIRON"),
  envir = getOption("envsetup.path.environment")
)
}
\arguments{
\item{lib}{object containing the paths for all environments of a directory}

\item{filename}{name of the file you would like to read}

\item{full.path}{logical to return the path including the file name}

\item{envsetup_environ}{name of the environment you would like to read the file from;
default values comes from the value in the system variable ENVSETUP_ENVIRON
which can be set by Sys.setenv(ENVSETUP_ENVIRON = "environment name")}

\item{envir}{The environment to search for the path object. Defaults to the
value of \code{getOption("envsetup.path.environment")}.}
}
\value{
string containing the path of the first directory the file is found
}
\description{
Check each environment for the file and return the path to the first.
}
\details{
The environments searched depends on the current environment.
For example, if your workflow contains a development (dev) area and
production area (prod), and the code is executing in the dev environment,
we search dev and prod. If in prod, we only search prod.
}
\examples{
tmpdir <- tempdir()

# account for windows
if (Sys.info()['sysname'] == "Windows") {
  tmpdir <- gsub("\\\\", "\\\\\\\\", tmpdir, fixed = TRUE)
}

# add config for just the data location
hierarchy <- paste0("default:
  paths:
    data: !expr list(
      DEV = file.path('",tmpdir,"', 'demo', 'DEV', 'username', 'project1', 'data'),
      PROD = file.path('",tmpdir,"', 'demo', 'PROD', 'project1', 'data'))")

# write config file to temp directory
writeLines(hierarchy, file.path(tmpdir, "hierarchy.yml"))

config <- config::get(file = file.path(tmpdir, "hierarchy.yml"))

# build folder structure from config
build_from_config(config)

# setup environment based on config
rprofile(config::get(file = file.path(tmpdir, "hierarchy.yml")))

# place data in prod data folder
saveRDS(mtcars, file.path(tmpdir, "demo/PROD/project1/data/mtcars.rds"))

# find the location of mtcars.rds
read_path(data, "mtcars.rds")
}
