% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eahu.R
\name{get_eahu}
\alias{get_eahu}
\title{Descarga de Bases de la Encuesta anual de hogares urbanos}
\usage{
get_eahu(year = 2010, type = "individual", vars = "all", destfile = NULL)
}
\arguments{
\item{year}{un integer o vector de integers entre 2010 y 2014}

\item{type}{tipo de base a descargar: 'individual' ; 'hogar'}

\item{vars}{opcional: un vector de characters. variables a seleccionar. Default = 'all' trae todas las variables}

\item{destfile}{opcional: un string con la direccion de un archivo .RDS. Si se ingresa un path a un archivo que no existe, se descarga
el archivo y se graba en esa direccion. Si existe un archivo en ese path, se lee el archivo.}
}
\value{
Devuelve la o las bases de la EAHU solicitadas
}
\description{
Funcion que descarga bases de la Encuesta anual de hogares urbanos del INDEC entre 2010 y 2014
}
\details{
disclaimer: El script no es un producto oficial de INDEC.
}
\examples{
base_individual <- get_eahu(
  year = 2010,
  type = "individual",
  vars = c("SUBDOMINIO", "PONDERA", "ESTADO", "CAT_OCUP")
)

}
