% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewnet.R
\name{ewnet}
\alias{ewnet}
\title{Ewnet: An Ensemble Wavelet Neural Network for Forecasting and Epicasting}
\usage{
ewnet(
  ts,
  Waveletlevels = floor(log(length(ts))),
  MaxARParam,
  boundary = "periodic",
  FastFlag = TRUE,
  NForecast,
  NVal = 0,
  measure = Metrics::mase,
  PI = FALSE,
  xreg_train = NULL,
  xreg_test = NULL,
  ret_fit = FALSE
)
}
\arguments{
\item{ts}{A numeric vector or time series}

\item{Waveletlevels}{An integer specifying the levels of decomposition. The default
is set to floor(log(length(ts))).}

\item{MaxARParam}{An integer indicating the maximum lagged observations to be included
in the neural network. The default is selected based on AIC using linear AR process.}

\item{boundary}{A character string indicating which boundary method to use.
boundary = "periodic" (default) and boundary = "reflection".}

\item{FastFlag}{A logical flag which, if true (default), indicates that the pyramid
algorithm is computed with an internal C function. Otherwise, only R code is used
in all computations.}

\item{NForecast}{An integer specifying the forecast horizon.}

\item{NVal}{An integer indicating the size of validation set. Default is set to 0.}

\item{measure}{The performance metric used for selecting the best value of \code{MaxARParam}
based on validation set. Defaults to Metrics::mase.}

\item{PI}{A logical flag which, if true generates the confidence interval for the
forecast horizon. Default is set to false.}

\item{xreg_train}{Optionally, a vector or matrix of external regressors, which
must have the same number of rows as \code{ts}. Must be numeric.}

\item{xreg_test}{Optionally, a vector or matrix of external regressors, which
must have the same number of rows as \code{NForecast} to be used for the forecast.
Must be numeric.}

\item{ret_fit}{A logical flag specifying that the fitted values of the model on the
training set should be returned if true, otherwise, false (default).}
}
\value{
The parameters of the fitted model indicating the number of lagged observations
included in the model and the number of nodes in the hidden layer. The forecast of the
time series of size \code{NForecast} is generated along with the optional output of
fitted values (\code{ret_fit} = TRUE) and confidence interval (\code{PI} = TRUE) for the forecast.
}
\description{
Ewnet: An Ensemble Wavelet Neural Network for Forecasting and Epicasting
}
\examples{
ewnet(ts = datasets::lynx, MaxARParam = 1, NForecast = 3)
}
\references{
\itemize{
\item Panja, M., Chakraborty, T., Kumar, U., & Liu, N. (2022).
Epicasting: An ensemble wavelet neural network (ewnet) for forecasting epidemics.
arXiv preprint arXiv:2206.10696. \url{https://arxiv.org/abs/2206.10696}

\item Panja, M., Chakraborty, T., Nadim, S. S., Ghosh, I., Kumar, U., & Liu, N. (2023).
An ensemble neural network approach to forecast Dengue outbreak based on climatic condition.
Chaos, Solitons & Fractals, 167, 113124.}
}
\author{
Madhurima Panja and Tanujit Chakraborty
}
