% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scc.R
\name{scc_cause_sets}
\alias{scc_cause_sets}
\title{Extracting component causes from SCC model}
\usage{
scc_cause_sets(
  scc,
  output = c("id", "desc", "desc_no_start", "all"),
  depends = TRUE,
  unknown = FALSE
)
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{output}{A single element of type character, which determines the type of output. Options are "id", "desc", "desc_no_start", and "all".
See returns-part below for description.}

\item{depends}{TRUE (default) or FALSE. If FALSE, only includes sufficient causes with sc_status "always".}

\item{unknown}{TRUE or FALSE (default). If TRUE, unknown causes are added to the SCC model: every sufficient cause gets an additional
individual unknown component cause representing additional unknown components; an unknown sufficient cause is added to the model consisting of
a single unknown component cause and representing all unknown sufficient causes.}
}
\value{
A named list but its content depends on parameter "output". The names correspond to the component cause set IDs, i.e., \verb{cc[[:digit:]]+}.
\itemize{
\item id: Returns a named list of character vectors. Each vector contains the step IDs of its component causes.
\item desc: Returns a named list of character vectors. Each vector contains the step descriptions of its component causes.
\item desc_no_start: Returns a named list of character vectors. Each vector contains the step descriptions of its component causes, but with the
"Start: " in the beginning removed.
\item all: A named list of the three lists above. The names correspond to the corresponding option for parameter "output".
}
}
\description{
Extracting component causes by sufficient cause from an \code{epicmodel_scc} object.
}
\examples{
# Create some SCC model
steplist_checked <- check_steplist(steplist_rain)
scc_model <- create_scc(steplist_checked)

# Get sets of component causes that form the sufficient causes
scc_cause_sets(scc_model, output = "all")
}
