% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.r
\name{get_non_high_school_wage_penalty}
\alias{get_non_high_school_wage_penalty}
\title{Retreive the percent by which hourly wages of workers without a high school diploma
(or equivalent) are less than wages of otherwise equivalent workers who have graduated
from high school}
\usage{
get_non_high_school_wage_penalty(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or \code{g} for a parition by gender}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
A regression-based non-high school wage penalty of 21.8 percent means that on average
workers without a high school diploma are paid 21.8 percent less per hour than workers
with a high school diploma, all else held equal (controlling for gender, race and
ethnicity, education, experience, and geographic location).
}
\examples{
\dontrun{
if (not_dos()) get_non_high_school_wage_penalty()

if (not_dos()) get_non_high_school_wage_penalty("g")
}
}
\references{
\href{https://www.epi.org/data/}{Economic Policy Institute Data Library}
}
