% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfuncs.R
\name{siragemod}
\alias{siragemod}
\title{Gradient-function for the age-structured SIR model with possibly heterogeneous mixing}
\usage{
siragemod(t, logx, parms)
}
\arguments{
\item{t}{Implicit argument for time}

\item{logx}{A vector with log-values for the log-states}

\item{parms}{A vector with parameter values for the age-structured SIR system}
}
\value{
A list of gradients
}
\description{
Gradient-function for the age-structured SIR model with possibly heterogeneous mixing
}
\examples{
a=rep(1,4)
n=length(a)
betaM=matrix(1, ncol=4, nrow=4)
pars =list(N=1, gamma=365/14, mu=0.02, sigma=0.2, beta=500, betaM=betaM,p=rep(0,4), a=a)
xstart<-log(c(S=rep(0.099/n,n), I=rep(0.001/n,n), R=rep(0.9/n,n)))
times=seq(0,10,by=14/365)
out=as.data.frame(ode(xstart, times=times, func=siragemod, parms=pars))
}
