% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owas_clogit.R
\name{owas_clogit}
\alias{owas_clogit}
\title{Perform 'omics wide association study for matched case control studies}
\usage{
owas_clogit(
  df,
  cc_status,
  cc_set,
  omics,
  covars = NULL,
  confidence_level = 0.95,
  conf_int = FALSE,
  method = "efron",
  test_data_quality = TRUE
)
}
\arguments{
\item{df}{Dataset}

\item{cc_status}{Name of the variable indicating case control status.
Must be either 0/1 or a factor with the first level representing the
reference group.}

\item{cc_set}{Name of the variable indicating the case control set.}

\item{omics}{Names of all omics features in the dataset
reference group.}

\item{covars}{Names of covariates (can be NULL)}

\item{confidence_level}{Confidence level for marginal significance
(defaults to 0.95, or an alpha of 0.05)}

\item{conf_int}{Should Confidence intervals be generated for the estimates?
Default is FALSE. Setting to TRUE will take longer. For logistic models,
calculates Wald confidence intervals via \code{confint.default}.}

\item{method}{method used the correct (exact) calculation in the
conditional likelihood or one of the approximations. Default is "efron".
Passed to \code{clogit}.}

\item{test_data_quality}{If TRUE (default), then code will ensure that
the variance of all variables in the analysis is greater than 0 after
dropping any missing data.}
}
\value{
A data frame with 6 columns:
feature_name: name of the omics feature
estimate: the model estimate for the feature. For linear models, this is the
beta; for logistic models, this is the log odds.
se: Standard error of the estimate
test statistic: t-value
p_value: p-value for the estimate
adjusted_pval: FDR adjusted p-value
threshold: Marginal significance, based on unadjusted p-values
}
\description{
Implements an omics wide association study for matched case control studies
using conditional logistic regression. For this function, the variable of
of interest should be a dichotomous outcome, and the strata is the variable
indicating the matching.
}
