% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{agg_index}
\alias{agg_index}
\title{Several aggregation indices.}
\usage{
agg_index(
  x,
  method = c("fisher", "lloyd", "morisita"),
  flavor = c("count", "incidence"),
  n = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector or a \code{count}/\code{incidence} object.}

\item{method}{The name of the method to be used. "fisher" method is used by
default. See details below.}

\item{flavor}{Which flavor of this index must be calculated ("count" or
"incidence")?}

\item{n}{Number of individuals per sampling unit. If \code{n} is provided,
the "incidence" flavor is calculated whatever the value of \code{flavor}.
Note that current implementation only deals with equal size sampling
units.}

\item{...}{Additional arguments to be passed to other methods.}
}
\value{
An object of class \code{agg_index}, which is a list containing the following
components:
\tabular{ll}{
    \code{index}  \tab The value of the index. \cr
    \code{name}   \tab The name of the index. \cr
    \code{flavor} \tab The flavor of the calculated index ("count" or "incidence"). \cr
    \code{N}      \tab The number of sampling units. \cr
    \code{n}      \tab The number of individuals in each sampling unit (if relevant). \cr
}
}
\description{
This function can compute different aggregation indices. See "Details"
section for more information about the available indices.
}
\details{
There are currently three implemented methods to compute indices of
aggregation.

\code{fisher}: Fisher's index of aggregation. In case of a count, this index
corresponds to the ratio of the observed variance to the observed mean, and
this is why this index is also known as the variance to mean ratio. For a
binary variable, a similar index can be calculated using instead the ratio of
the observed variance to the theoretical variance if data follow a binomial
law (i.e. a reference distribution for a random pattern of individuals within
sampling units).

\code{lloyd}: Lloyd's index of patchiness. The value of this index increases
with the degree of aggregation. Note that Lloyd's mean crowding can also be
returned if \code{type = "mean-crowding"} is provided as parameter.

\code{morisita}: Morisita's coefficient of dispersion. This index can be
computed for either count or incidence data, but its interpretation can be
uncertain.

Values of Fisher's and Lloyd's indices can be interpreted as follows:
\itemize{
    \item index < 1: uniform pattern;
    \item index = 1: random pattern;
    \item index > 1: aggregated pattern.
}

The following table gives information about the applicability of the various
methods.

\tabular{llll}{
    \tab count \tab incidence \tab severity \cr
    fisher   \tab + \tab + \tab - \cr
    lloyd    \tab + \tab - \tab - \cr
    morisita \tab + \tab + \tab - \cr
}
where + means implemented, and -, not implemented (or not possible). At the
moment, there is no index of aggregation for severity data.
}
\examples{
# Count flavor of Fisher's index:
my_fisher_count <- agg_index(aphids$i)
my_fisher_count

# And incidence flavor of Fisher's index:
my_fisher_incidence <- agg_index(tobacco_viruses$i, n = tobacco_viruses$n)
my_fisher_incidence

# Either standard R or epiphy idioms can be used:
identical(my_fisher_count, agg_index(count(aphids)))
identical(my_fisher_incidence, agg_index(incidence(tobacco_viruses)))

# Lloyd's index (only for count data):
agg_index(aphids$i, method = "lloyd")
# Lloyd's mean crowding:
agg_index(aphids$i, method = "lloyd", type = "mean-crowding")

# Count flavor of Morisita's index:
agg_index(aphids$i,  method = "morisita")
# Incidence flavor of Morisita's index:
agg_index(tobacco_viruses$i, n = tobacco_viruses$n, method = "morisita")

}
\references{
Fisher RA. 1925. Statistical methods for research workers. Oliver and Boyd,
Edinburgh.

Lloyd M. 1967. Mean crowding. The Journal of Animal Ecology 36, 1–30.

Morisita M. 1962. I\eqn{\delta}-Index, a measure of dispersion of
individuals. Researches on Population Ecology 4, 1–7.
\doi{10.1007/BF02533903}

Madden LV, Hughes G. 1995. Plant disease incidence: Distributions,
heterogeneity, and temporal analysis. Annual Review of Phytopathology 33(1):
529–564.
\doi{10.1146/annurev.py.33.090195.002525}
}
\seealso{
\code{\link[vegan]{vegdist}} in \strong{vegan} package.
}
