% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{create_epitrax_from_file}
\alias{create_epitrax_from_file}
\title{Create an EpiTrax object from data file}
\usage{
create_epitrax_from_file(filepath = NULL, num_yrs = 5)
}
\arguments{
\item{filepath}{Optional filepath. EpiTrax data file should be a CSV. If this parameter
is NULL, the user will be prompted to choose a file interactively.}

\item{num_yrs}{Integer. Number of years of data to keep. Defaults to 5.}
}
\value{
An object of class \code{epitrax} containing:
\itemize{
\item \code{data}: The validated and formatted EpiTrax data
\item \code{diseases}: Vector of unique diseases in the dataset
\item \code{yrs}: Vector of years in the dataset
\item \code{report_year}: Most recent year in the dataset
\item \code{report_month}: Most recent month in report_year
\item \code{internal_reports}: Empty list to store internal reports
\item \code{public_reports}: Empty list to store public reports
}
}
\description{
\code{create_epitrax_from_file} reads an EpiTrax data file and creates a structured object
containing the data along with commonly used metadata and empty report lists.
}
\examples{
if (interactive()) {
  # Interactive file chooser:
  create_epitrax_from_file()
}

# Using sample data included with package
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
epitrax <- create_epitrax_from_file(data_file)

# Access components
head(epitrax$data)
epitrax$diseases
epitrax$report_year
}
\seealso{
\code{\link[=read_epitrax_data]{read_epitrax_data()}} which this function wraps and
\code{\link[=setup_epitrax]{setup_epitrax()}} which wraps this function
}
