% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_report_monthly_medians}
\alias{epitrax_report_monthly_medians}
\title{Create monthly medians report from an EpiTrax object}
\usage{
epitrax_report_monthly_medians(
  epitrax,
  is.public = FALSE,
  exclude.report.year = FALSE
)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{is.public}{Logical indicating whether to generate a public report using
the public disease list. If FALSE (default), generates an internal report using
the internal disease list.}

\item{exclude.report.year}{Logical indicating whether to exclude the current
report year from the report. Defaults to FALSE.}
}
\value{
Updated EpiTrax object with monthly medians report added to either
the \code{internal_reports} or \code{public_reports} field, depending on the \code{is.public}
parameter.
}
\description{
\code{epitrax_report_monthly_medians} generates a report of monthly medians for all years
in the EpiTrax object data, with the option to exclude the current report year.
It can be run for either internal or public reports.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_report_monthly_medians()

names(epitrax$internal_reports)
}
