% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{setup_epitrax}
\alias{setup_epitrax}
\title{Setup EpiTrax object with configuration and disease lists}
\usage{
setup_epitrax(
  filepath = NULL,
  num_yrs = 5,
  disease_list_files = NULL,
  config_list = NULL,
  config_file = NULL
)
}
\arguments{
\item{filepath}{Optional filepath. EpiTrax data file should be a CSV. If this parameter
is NULL, the user will be prompted to choose a file interactively.}

\item{num_yrs}{Integer. Number of years of data to keep. Defaults to 5.}

\item{disease_list_files}{Optional list containing filepaths to internal and
public report disease lists. If omitted, the default lists will be used and
a warning will be given.}

\item{config_list, config_file}{Configuration options may be specified as a
list or as a path to a YAML config file, respectively. Only one can be
specified at a time. If both are specified, the function will return an
error. If both are omitted, the default config values will be used.}
}
\value{
An EpiTrax object with configuration and report diseases set.
}
\description{
\code{setup_epitrax} initializes an EpiTrax object with configuration and report
disease lists. It is a convenience function that combines \code{create_epitrax_from_file()},
\code{epitrax_set_config_from_file()}, and \code{epitrax_set_report_diseases()}.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
disease_lists <- list(
  internal = system.file("tinytest/test_files/disease_lists/internal_list.csv",
                         package = "epitraxr"),
  public = system.file("tinytest/test_files/disease_lists/public_list.csv",
                       package = "epitraxr")
)

epitrax <- setup_epitrax(
  filepath = data_file,
  disease_list_files = disease_lists
)
}
\seealso{
\code{\link[=create_epitrax_from_file]{create_epitrax_from_file()}}, \code{\link[=epitrax_set_config_from_file]{epitrax_set_config_from_file()}},
\code{\link[=epitrax_set_config_from_list]{epitrax_set_config_from_list()}}, and \code{\link[=epitrax_set_report_diseases]{epitrax_set_report_diseases()}}
which this function wraps.
}
