% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_discrete.R
\name{fit_disc_gamma}
\alias{fit_disc_gamma}
\alias{fit_discrete}
\title{Fit discretised distributions using ML}
\usage{
fit_disc_gamma(x, mu_ini = NULL, cv_ini = NULL, interval = 1, w = 0, ...)
}
\arguments{
\item{x}{A vector of numeric data to fit; NAs will be removed with a warning.}

\item{mu_ini}{The initial value for the mean 'mu', defaulting to the empirically
calculated value.}

\item{cv_ini}{The initial value for the coefficient of variation 'cv',
defaulting to the empirically calculated value.}

\item{interval}{The interval used for discretisation; see
\code{\link[distcrete]{distcrete}}.}

\item{w}{The centering of the interval used for discretisation; see
\code{\link[distcrete]{distcrete}}.}

\item{...}{Further arguments passed to \code{\link{optim}}.}
}
\value{
The function returns a list with human-readable parametrisation of
  the discretised Gamma distibution (mean, sd, cv), convergence indicators,
  and the discretised Gamma distribution itself as a \code{distcrete} object
  (from the \code{distcrete} package).
}
\description{
These functions performs maximum-likelihood (ML) fitting of a discretised
distribution. This is typically useful for describing delays between
epidemiological events, such as incubation period (infection to onset) or
serial intervals (primary to secondary onsets). The function
\code{\link{optim}} is used internally for fitting.
}
\examples{

## generate data

mu <- 15.3 # days
sigma <- 9.3 # days
cv <- sigma / mu
cv
param <- gamma_mucv2shapescale(mu, cv)

if (require(distcrete)) {
w <- distcrete("gamma", interval = 1,
               shape = param$shape,
               scale = param$scale, w = 0)

x <- w$r(100)
x

fit_disc_gamma(x)
}

}
\seealso{
The \code{distcrete} package for discretising distributions, and
\code{\link{optim}} for details on available optimisation procedures.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}

Charlie Whittaker \email{charles.whittaker16@imperial.com}
}
