% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationHandler.R
\name{SimulationHandler}
\alias{SimulationHandler}
\title{R6 class representing a simulation handler.}
\description{
\code{\link[R6:R6Class]{R6::R6Class}} class to represent a handler for running multiple model
simulations and saving results. This simulation manager bears some
resemblance to the \code{\link[poems:SimulationManager]{poems::SimulationManager}} in \code{poems}, but differs
in that it can handle multiple dispersal generators, uses a different engine
for parallelization, handles errors differently, and has a different default
data format (\code{.qs2}).
}
\keyword{internal}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericManager]{poems::GenericManager}} -> \code{SimulationHandler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value
pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sample_data}}{A data frame of sampled parameters for each simulation/result.}

\item{\code{model_template}}{A \code{\link[poems:SimulationModel]{poems::SimulationModel}} (or inherited class)
object with parameters common to all simulations.}

\item{\code{nested_model}}{A \code{\link[poems:SimulationModel]{poems::SimulationModel}} (or inherited class)
object with empty sample parameters and a nested model template common to
all simulations.}

\item{\code{generators}}{A list of generators (\code{\link[poems:Generator]{poems::Generator}} or inherited
class) objects for generating simulation model values.}

\item{\code{model_simulator}}{A \code{\link[poems:ModelSimulator]{poems::ModelSimulator}} (or inherited class)
object for running the simulations.}

\item{\code{parallel_cores}}{Number of cores for running the simulations in
parallel.}

\item{\code{results_dir}}{Results directory path.}

\item{\code{results_ext}}{Result file extension (default is .RData).}

\item{\code{results_filename_attributes}}{A vector of: prefix (optional);
attribute names (from the sample data frame); postfix (optional);
utilized to construct results filenames.}

\item{\code{error_messages}}{A vector of error messages encountered when setting
model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when
setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SimulationHandler-new}{\code{SimulationHandler$new()}}
\item \href{#method-SimulationHandler-log_simulation}{\code{SimulationHandler$log_simulation()}}
\item \href{#method-SimulationHandler-set_model_sample}{\code{SimulationHandler$set_model_sample()}}
\item \href{#method-SimulationHandler-run}{\code{SimulationHandler$run()}}
\item \href{#method-SimulationHandler-clone}{\code{SimulationHandler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericClass" data-id="new_clone"><a href='../../poems/html/GenericClass.html#method-GenericClass-new_clone'><code>poems::GenericClass$new_clone()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericManager" data-id="get_attribute"><a href='../../poems/html/GenericManager.html#method-GenericManager-get_attribute'><code>poems::GenericManager$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericManager" data-id="get_message_sample"><a href='../../poems/html/GenericManager.html#method-GenericManager-get_message_sample'><code>poems::GenericManager$get_message_sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericManager" data-id="get_results_filename"><a href='../../poems/html/GenericManager.html#method-GenericManager-get_results_filename'><code>poems::GenericManager$get_results_filename()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationHandler-new"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationHandler-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets any included attributes (\emph{sample_data},
\emph{model_template}, \emph{generators}, \emph{model_simulator},
\emph{parallel_cores}, \emph{results_dir},
\emph{results_filename_attributes}) and attaches other attributes
individually listed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationHandler$new(model_template = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_template}}{A SimulationModel (or inherited class) object with
parameters common to all simulations.}

\item{\code{...}}{Parameters listed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationHandler-log_simulation"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationHandler-log_simulation}{}}}
\subsection{Method \code{log_simulation()}}{
Summarizes the simulation log and writes it to a text file.

This method takes a nested list of simulation log entries generated by
the \code{run} method and summarizes the log. It determines which simulations
were successful, collects any warnings, and writes the summary to a text
file in the results directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationHandler$log_simulation(simulation_log)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{simulation_log}}{A nested list of simulation log entries.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing the summary, indices of failed simulations,
indices of simulations with warnings, and the full log.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationHandler-set_model_sample"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationHandler-set_model_sample}{}}}
\subsection{Method \code{set_model_sample()}}{
Sets the model sample attributes via the sample data frame and the
generators.

This method sets the sample attributes of a SimulationModel object based
on the specified sample index. It uses the sample data frame and the
generators to determine the attribute values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationHandler$set_model_sample(model, sample_index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{\code{\link[poems:SimulationModel]{poems::SimulationModel}} (or inherited class) object
(clone) to receive sample attributes.}

\item{\code{sample_index}}{Index of sample from data frame.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationHandler-run"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationHandler-run}{}}}
\subsection{Method \code{run()}}{
Runs the multiple population simulations, stores the
results, and creates a simulation log.

This method runs multiple population simulations using the specified
model template and sample data. It stores the simulation results in the
specified results directory and creates a simulation log. The simulation
log contains information about the success or failure of each simulation
run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationHandler$run(results_dir = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{results_dir}}{Results directory path where the simulation results
will be stored. If not provided, the results directory must be set
within the manager class object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list representing the simulation log. Each element of the list
corresponds to a simulation run and contains information about the
success or failure of the run, any error messages, and the path to the
saved results file (if applicable).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationHandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationHandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
