% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{get_object_info}
\alias{get_object_info}
\title{Format object information string}
\usage{
get_object_info(
  dt_object,
  component = c("id", "name", "class"),
  by_class = FALSE,
  numbered = TRUE,
  collapse = NULL,
  prefix = NULL,
  name_prefix = TRUE
)
}
\arguments{
\item{dt_object}{A \code{\link[data.table:data.table]{data.table::data.table()}} of object data}

\item{component}{A character vector specifying what information to be
formatted. Should be a subset of \code{"id"}, \code{"name"} and \code{"class"}.
Defaults are all of them.}

\item{by_class}{If \code{TRUE}, multiple objects in the same class will be
concatenated. Default: \code{FALSE}.}

\item{numbered}{If \code{TRUE}, a index number will be prepended. If \code{rleid}
column exists in \code{dt_object}, its values will be used as the index
numbers.}

\item{collapse}{A single string used to collapse the results into a single
string. Default: \code{NULL}.}

\item{prefix}{A character vector used to add at the beginning of object
information. Default: \code{NULL}.}

\item{name_prefix}{If \code{TRUE}, Default: \code{TRUE}.}
}
\value{
A character vector of the same length as the row number of input
\code{dt_object} if \code{collapse} is \code{NULL}. Otherwise a single string.
}
\description{
Format object information string
}
\keyword{internal}
