% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srtAddIntervention.R
\name{srtAddIntervention}
\alias{srtAddIntervention}
\title{Add a New Intervention Group to Simple Randomized Trial (SRT) Data}
\usage{
srtAddIntervention(
  existing_data,
  np,
  es,
  attritionrate,
  outcome,
  interventions,
  id,
  continuous_covariates,
  categorical_covariates
)
}
\arguments{
\item{existing_data}{A data frame containing the variables including outcome, predictors, the clustering variable, and the intervention for CRT design.}

\item{np}{The number of new participants to generate for the new intervention group.}

\item{es}{The standardized effect size for the new intervention group.}

\item{attritionrate}{The proportion of pupils in the new group to drop due to attrition.}

\item{outcome}{A string specifying the name of the column containing outcome variable (post-test scores).}

\item{interventions}{A string specifying the name of the intervention assignment column.}

\item{id}{A string specifying the name of the participant ID column.}

\item{continuous_covariates}{A character vector specifying the names of continuous covariates.}

\item{categorical_covariates}{A character vector specifying the names of categorical covariates (converted to factors).}
}
\value{
A \code{data.frame} combining the original dataset with the newly simulated intervention group.
}
\description{
This function adds a new intervention group to an existing SRT dataset by generating
new participant-level data.
}
\examples{
data(srt4armSimData)
new_srt5armData <- srtAddIntervention(existing_data = srt4armSimData, np = 100, 
es = 0.3, attritionrate = 0.1, outcome = "posttest", interventions = "interventions",
id = "ID", continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"))
head(new_srt5armData)

}
